C
C  CRITICALITY AND YIELD TIME-DEPENDENT SIMULATION WITH CORE + TAMPER 
C
C
C  THIS VERSION MARCH 2020:  SAMERDRSIM.  MODIFIED FROM 3RD EDITION OF MP PHYSICS BOOK,
C  TAMPER AND CORE GET SAME DELTA-RADIUS TO SIMULATE UNIFORM EXPANSION SPEED 
C  AT ALL TIMES
C
C  CORE DECLARATIONS
C
      DOUBLE PRECISION RHOCOR,RHOCORZ,ACOR,SIGFCOR,SIGSCOR,NU
      DOUBLE PRECISION NCOR,VEL,TAU,LAMFCOR,LAMTCOR,DCOR,ETACOR
      DOUBLE PRECISION X1,X2,RTBIS
C
C  TAMPER DECLARATIONS
C
      DOUBLE PRECISION RHOTAMP,RHOTAMPZ,ATAMP,SIGSTAMP,RTAMP,NTAMP,LAMTTAMP,MASSTAMP
C
C  SUPERCRITICALITY DECLARATIONS
C
      DOUBLE PRECISION CORMASS,CORRAD,ALPHA
C
C  SIMULATION DECLATARIONS
C
      DOUBLE PRECISION KILOTON,GAM,NEUTS,DT,TIME,RC,RT,NEUTDEN,VCOR,VTAMP
      DOUBLE PRECISION ENERGY,DELTAE,FISSRATE,PRESS,CORVEL,DELTAV,MTOT
C
C  GENERAL VARIABLES
C
      DOUBLE PRECISION NA,EPS,PI,MNEUT,EFISS,ENEUT
C
      OPEN(UNIT=1,FILE='CRITVALS',STATUS='OLD')
      OPEN(UNIT=2,FILE='SAMEDR-RESULTS')
      OPEN(UNIT=3,FILE='SAMEDR-PLOT')
C
C  SET GENERAL VARIABLES.  EPS IS JOULES PER MEV; EF IS MEV PER FISSION; NEEDED
C  FOR SIMULATION
C
      NA = 6.022142D+23
      EPS = 1.602176D-13
      PI = 3.14159265359
      MNEUT = 1.674927D-27
      EFISS = 180.0
      ENEUT = 2.0
      KILOTON = 4.2D+12
C
C  READ IN CORE VALUES, TRANSFORM SIGMAS TO SQUARE METERS
C  COMPUTE VARIOUS QUANTITIES.  SAVE INITIAL DENSITY AS RHOCORZ
C
      READ(1,*) RHOCORZ,ACOR,SIGFCOR,SIGSCOR,NU
      RHOCOR = RHOCORZ
      SIGFCOR = 1.0D-28*SIGFCOR
      SIGSCOR = 1.0D-28*SIGSCOR
      NCOR = 1.0D+06*RHOCOR*NA/ACOR
      VEL = DSQRT(2*EPS*ENEUT/MNEUT)
      LAMFCOR = 1.0D+00/(SIGFCOR*NCOR)
      LAMTCOR = 1.0D+00/((SIGFCOR+SIGSCOR)*NCOR)
      TAU = LAMFCOR/VEL
      DCOR = DSQRT((LAMFCOR*LAMTCOR)/(3.*(NU-1.)))
      ETACOR = 2.*LAMTCOR/(3.*DCOR)
C
C  PRINT CORE VALUES
C
      WRITE(2,800)
      WRITE(2,805)
      WRITE(2,804)
      WRITE(2,812) RHOCOR
      WRITE(2,816) ACOR
      WRITE(2,820) 1.0D+28*SIGFCOR, 1.0D+28*SIGSCOR
      WRITE(2,824) NU
      WRITE(2,828) EFISS, ENEUT
      WRITE(2,804)
      WRITE(2,832) NCOR/(1.0D+28)
      WRITE(2,836) VEL/(1.0D+07)
      WRITE(2,840) (1.0D+09)*TAU
      WRITE(2,844) LAMFCOR*100.
      WRITE(2,848) LAMTCOR*100.
      WRITE(2,852) 100.*DCOR
      WRITE(2,854) ETACOR
C
C  READ IN TAMPER PARAMETERS; GET TAMPER NUMBER DENSITY 
C
      READ(1,*) RHOTAMPZ,ATAMP,SIGSTAMP
      RHOTAMP = RHOTAMPZ
      SIGSTAMP = 1.0D-28*SIGSTAMP
      NTAMP = 1.0D+06*RHOTAMP*NA/ATAMP
      LAMTTAMP = 1.0D+00/(SIGSTAMP*NTAMP)
C
C  PRINT RESULTS FOR TAMPER DATA
C
      WRITE(2,872)
      WRITE(2,804)
      WRITE(2,874) RHOTAMP
      WRITE(2,878) ATAMP
      WRITE(2,882) 1.0D+28*SIGSTAMP
      WRITE(2,886) NTAMP/(1.0D+28)
      WRITE(2,890) 100.*LAMTTAMP
C
C  GO ON TO TAMPED SUPER-CRITICALITY WITH ASSUMED CORE AND TAMPER MASSES
C
C  READ IN THE CORE AND TAMPER MASSES IN KG. GET RADII IN METERS FROM THE DENSITIES IN G/CM^3
C  SET INITIAL LOW-END GEUSS FOR ALPHA AS JUST ABOVE ZERO
C  HIGH-END GUESS AS (NU-1) MINUS A BIT TO AVOID BLOW-UPS
C
      READ(1,*) CORMASS,MASSTAMP
      CORRAD = ((3.*CORMASS)/(4.*PI*1000.*RHOCOR))**(1./3.)
      RTAMP =  ((3./(4.*PI))*(MASSTAMP/(1000.*RHOTAMP) + CORMASS/(1000.*RHOCOR)))**(1./3.)
      X1 = 0.01
      X2 = (NU-1.01)
C
C  CALL THE TAMPER SUPER-CRIT BISECTION ROUTINE TO DETERMINE ALPHA
C
      CALL SUPERTAMP(X1,X2,LAMTTAMP,LAMFCOR,LAMTCOR,NU,RTAMP,CORRAD,RTBIS)
      ALPHA = RTBIS
C
C  WRITE CORE AND TAMPER MASSES
C
      WRITE(2,804)
      WRITE(2,914) CORMASS,100.*CORRAD
      WRITE(2,920) MASSTAMP,100.*RTAMP
      WRITE(2,922) ALPHA
C
C  GO ON TO SIMULATION
C
C  READ IN GAMMA, NUMBER OF INITIAL NEUTS, STARTING TIME, TIMESTEP
C
      READ(1,*) GAM,NEUTS,TIME,DT
      WRITE(2,923) NEUTS
      WRITE(2,804)
      WRITE(2,804)
      WRITE(2,925)
      WRITE(2,804)
C
C  SET CORE AND TAMPER RADII TO THOSE ABOVE. SET TOTAL MASS TO
C  SUM OF CORE PLUS TAMPER MASS. GET INITIAL NEUT DENSITY 
C  ALSO INITIALIZE TIME, ENERGY, PRESSURE, CORE VELOCITY
C
      RC = CORRAD
      RT = RTAMP
      VCOR = (4.*PI/3.)*(RC**3.)
      VTAMP = (4.*PI/3.)*(RT**3. - RC**3.)
      NEUTDEN = NEUTS/VCOR
      MTOT = CORMASS + MASSTAMP
      ENERGY = 0.0D+00
      PRESS = 0.0D+00
      CORVEL = 0.0D+00
C
C  PROGRAM LOOPS BACK TO HERE AT EACH TIMESTEP
C
  500 CONTINUE
C
C  FOR CURRENT RADIUS, DETERMINE ALPHA. SET LOWER
C  GUESS ON ALPHA AS A NEGATIVE NUMBER, AND HIGH GUESS TO A BIT LESS THAN CURRENT VALUE.
C  THEN RUN SUBROUTINE TO UPDATE ALPHA
C  THE CORE HAS EXPANDED, SO ITS DENSITY CHANGES. SO FIRST RECOMPUTE
C  DENSITY IN GR/CM^3 FROM CURRENT CORE VOLUME, GET NEW NUMBER DENSITY, LAMBDAS, AND TAU.  
C  ALSO RECOMPUTE DENSITY AND LAMBDAS FOR TAMPER
C  RADII IN CM
C
      X1 = -0.1
      X2 = ALPHA - 1.0D-10
      RHOCOR = CORMASS/(1000.*VCOR)
      RHOTAMP = MASSTAMP/(1000.*VTAMP)
      NTAMP = 1.0D+06*RHOTAMP*NA/ATAMP
      LAMTTAMP = 1.0D+00/(SIGSTAMP*NTAMP)      
      NCOR = 1.0D+06*RHOCOR*NA/ACOR
      LAMFCOR = 1.0D+00/(SIGFCOR*NCOR)
      LAMTCOR = 1.0D+00/((SIGFCOR+SIGSCOR)*NCOR)
      TAU = LAMFCOR/VEL
      CALL SUPERTAMP(X1,X2,LAMTTAMP,LAMFCOR,LAMTCOR,NU,RT,RC,ALPHA)
C
C  GET FISSION RATE, AND AMOUNT OF ENERGY EMITTED DURING THIS TIMESTEP
C  UPDATE ENERGY RELEASE, PRESSURE, CORE VELOCITY
C
      FISSRATE = (NEUTDEN*VCOR/TAU)*DEXP(ALPHA*TIME/TAU)
      DELTAE = FISSRATE*EPS*EFISS*DT
      ENERGY = ENERGY + DELTAE
      PRESS = GAM*ENERGY/VCOR
      DELTAV = ((4.*PI*(RC**2.)*GAM*ENERGY)/(VCOR*MTOT))*DT
C
C  RECORD TIME (MICROSEC), ALPHA, CORE RADIUS (CM), CORE DENSITY, 
C  TAMPER RADIUS AND DENSITY, YIELD (KT) AT THIS STEP BEFORE UPDATING
C  VELOCITY AND SIZES
C
      WRITE(2,930) TIME/1.0D-06,ALPHA,100.*RC,RHOCOR,100.*RT,RHOTAMP,DLOG10(FISSRATE),DLOG10(PRESS),ENERGY/KILOTON
      WRITE(3,930) TIME/1.0D-06,ALPHA,100.*RC,RHOCOR,100.*RT,RHOTAMP,DLOG10(FISSRATE),DLOG10(PRESS),ENERGY/KILOTON
      TIME = TIME + DT
C
C  UPDATE CORE VELOCITY, RADIUS, VOLUME
C  PROGRAM CONTINUES UNTIL ALPHA DECLINES TO SECOND CRITICALITY
C
      CORVEL = CORVEL + DELTAV
      RC = RC + CORVEL*DT
      RT = RT + CORVEL*DT
      VCOR = (4.*PI/3.)*(RC**3.)
      VTAMP = (4.*PI/3.)*(RT**3.) - VCOR
      IF (ALPHA.LT.0.0001) GOTO 998
      GOTO 500
C
  998 WRITE(2,935) CORVEL/1000.
      GOTO 999
      
  800 FORMAT(1X,'-----------------------------------------------------')
  804 FORMAT(1X,' ')
  805 FORMAT(1X,'TIME-DEPENDENT SIMULATION INPUT AND DERIVED CORE PARAMETERS ')
  812 FORMAT(1X,'CORE DENSITY   ',F6.2,' gr/cm^3')
  816 FORMAT(1X,'CORE ATOMIC WT ',F7.2,' gr/mol')
  820 FORMAT(1X,'CORE FISSION, SCATT SIGMAS ',2F8.3,' barns')
  824 FORMAT(1X,'NEUTRONS PER FISSION ',F7.3)
  828 FORMAT(1X,'FISSION AND NEUTRON ENERGY ',2F7.1,' MEV')
  832 FORMAT(1X,'CORE NUMBER DENSITY ',F7.3,' 10^28 M^-3')
  836 FORMAT(1X,'NEUTRON VELOCITY ',F7.3,' 10^7 m/sec')
  840 FORMAT(1X,'TAU              ',F7.3,' nanosec')
  844 FORMAT(1X,'CORE FISSION MFP  ',F7.3,' cm')
  848 FORMAT(1X,'CORE TOTAL MFP    ',F7.3,' cm')
  852 FORMAT(1X,'BARE CORE D-VALUE ',F7.3,' cm')
  854 FORMAT(1X,'CORE ETA VALUE    ',F7.3,' No units')
  872 FORMAT(1X,'TAMPED THRESHOLD CRITICALITY')
  874 FORMAT(1X,'TAMPER DENSITY   ',F6.2,' gr/cm^3')
  878 FORMAT(1X,'TAMPER ATOMIC WT ',F7.2,' gr/mol')
  882 FORMAT(1X,'TAMPER SCATT SIGMA ',F8.3,' barns')
  886 FORMAT(1X,'TAMPER NUMBER DENSITY ',F7.3,' 10^28 M^-3')
  890 FORMAT(1X,'TAMPER LAMBDA         ',F7.3,' cm')
  914 FORMAT(1X,'CORE MASS & RADIUS    ',F7.2,' kg',3X,F7.3,'  cm')
  920 FORMAT(1X,'TAMPER MASS & RADIUS  ',F7.2,' kg',3X,F7.3,'  cm')
  922 FORMAT(1X,'INITIAL ALPHA    ',F10.7)
  923 FORMAT(1X,'INITIAL NEUTRONS ',F5.0)
  925 FORMAT(1X,'TIME(mu)     ALPHA     R(CORE)      RHOC    R(TAMP)   RHOT   LOG(FISSRATE)    LOG(PRESS)    YIELD')
  930 FORMAT(1X,F8.4,4X,F8.5,4X,F7.3,4X,F7.3,4X,F7.3,4X,F7.3,4X,F7.3,4X,F7.3,4X,F8.4)
  935 FORMAT(1X,'FINAL CORE VELOCITY (km/s)  ',F7.2)
  999 STOP
      END
C ***************************************************************
C
C  TAMPED SUPER-CRITCALITY SUBROUTINE
C
C  MANY INTERNAL VARIABLES HERE
C
      SUBROUTINE SUPERTAMP(X1,X2,LAMTTAMP,LAMFCOR,LAMTCOR,NU,RTAMP,CORRAD,RTBIS)
      REAL*8 X1,X2,LAMTTAMP,LAMFCOR,LAMTCOR,NU,RTAMP,CORRAD,XMID
      REAL*8 XACC,F,FMID,RTBIS,DX
      REAL*8 EXPT,UPLEFT,LOWLEFT,UPRITE,LOWRITE
C
C  DECLARE VARIABLES FOR FACTORS IN CRITICALITY EQUATION CORRESPONDING TO X1,X2,XMID
C
      REAL*8 DTAM1,DCOR1,XCT1,XC1,XT1,LAM
      REAL*8 DTAM2,DCOR2,XCT2,XC2,XT2
      REAL*8 DTAMM,DCORM,XCTM,XCM,XTM
C
      INTEGER JMAX
      XACC = 1.0D-09
      JMAX = 40
      LAM = LAMTTAMP/LAMTCOR
C
C  EVALUATE FMID AT X2
C
      DTAM2 = DSQRT((LAMTTAMP*LAMFCOR)/(3.*X2))
      DCOR2 = DSQRT((LAMFCOR*LAMTCOR)/(3.*(-X2+NU-1.)))
      XCT2 = CORRAD/DTAM2
      XC2 = CORRAD/DCOR2
      XT2 = RTAMP/DTAM2
      EXPT = DEXP(2.*(XCT2-XT2))
      UPLEFT = XC2/DTAN(XC2) - 1. - LAM*(XCT2-1.)
      LOWLEFT = RTAMP + 2.*LAMTTAMP*(XT2-1.)/3.
      UPRITE = XC2/DTAN(XC2) - 1. + LAM*(XCT2+1.)
      LOWRITE = RTAMP - 2.*LAMTTAMP*(XT2+1.)/3.
      FMID = EXPT*(UPLEFT/LOWLEFT) - (UPRITE/LOWRITE)
C
C  EVALUATE F AT X1
C
      DTAM1 = DSQRT((LAMTTAMP*LAMFCOR)/(3.*X1))
      DCOR1 = DSQRT((LAMFCOR*LAMTCOR)/(3.*(-X1+NU-1.)))
      XCT1 = CORRAD/DTAM1
      XC1 = CORRAD/DCOR1
      XT1 = RTAMP/DTAM1
      EXPT = DEXP(2.*(XCT1-XT1))
      UPLEFT = XC1/DTAN(XC1) - 1. - LAM*(XCT1-1.)
      LOWLEFT = RTAMP + 2.*LAMTTAMP*(XT1-1.)/3.
      UPRITE = XC1/DTAN(XC1) - 1. + LAM*(XCT1+1.)
      LOWRITE = RTAMP - 2.*LAMTTAMP*(XT1+1.)/3.
      F = EXPT*(UPLEFT/LOWLEFT) - (UPRITE/LOWRITE)
C
      IF (F*FMID.GE.0.) PAUSE 'Root not bracketed'
      IF (F.LT.0.) THEN
        RTBIS = X1
        DX = X2-X1
      ELSE
        RTBIS = X2
        DX = X1-X2
      ENDIF
      DO 11 J=1,JMAX
      DX = 0.5*DX
      XMID = RTBIS+DX
C
C  EVALUATE FMID AT XMID
C
      DTAMM = DSQRT((LAMTTAMP*LAMFCOR)/(3.*XMID))
      DCORM = DSQRT((LAMFCOR*LAMTCOR)/(3.*(-XMID+NU-1.)))
      XCTM = CORRAD/DTAMM
      XCM = CORRAD/DCORM
      XTM = RTAMP/DTAMM
      EXPT = DEXP(2.*(XCTM-XTM))
      UPLEFT = XCM/DTAN(XCM) - 1. - LAM*(XCTM-1.)
      LOWLEFT = RTAMP + 2.*LAMTTAMP*(XTM-1.)/3.
      UPRITE = XCM/DTAN(XCM) - 1. + LAM*(XCTM+1.)
      LOWRITE = RTAMP - 2.*LAMTTAMP*(XTM+1.)/3.
      FMID = EXPT*(UPLEFT/LOWLEFT) - (UPRITE/LOWRITE)
C      
      IF (FMID.LT.0.) RTBIS=XMID
      IF ((ABS(DX).LT.XACC).OR.(FMID.EQ.0.)) RETURN
   11 CONTINUE
      PAUSE 'TOO MANY ITERATIONS IN TAMPED SUPER-CRITICALITY ROUTINE'
      END
C ***************************************************************
     

